IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HealthProviderIndividualInsert]') AND type in (N'P', N'PC'))
BEGIN
	DROP PROCEDURE [hips].[HealthProviderIndividualInsert]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO


-- =============================================

-- Create date: 2 April 2012
-- Description:   Inserts a new record into the Health Care Provider Table
-- 22/10/2012 Changed return the data fully populated
-- 29/09/2015 Added HealthProviderIndividualHpii
-- 05/02/2016 Allow HPI-I status to be updated.
-- 12/02/2016 Allow health provider individuals with no given names to be saved.
-- =============================================

CREATE PROCEDURE [hips].[HealthProviderIndividualInsert] 
(
	@IamProviderIdentifier VARCHAR(30) = NULL,
	@HpiI VARCHAR(16) = NULL,
	@HpiiLastValidated DATETIME = NULL,
	@HpiiStatusId INT = -1,
	@TitleId INT,
	@FamilyName VARCHAR(80),
	@GivenNames VARCHAR(100) = NULL,
	@DeactivatedDate DATETIME = NULL,
	@SuffixId INT,
	@UserModified VARCHAR(256),
	@HealthProviderOrganisationNetworkId INT,
	@LocalProviderCode VARCHAR(256) = NULL
) 
AS
BEGIN
	SET NOCOUNT ON

   DECLARE @intErrorCode int
          , @HealthProviderIndividualId INT
          
    SET @intErrorCode = 0
	INSERT INTO HealthProviderIndividual
	        ( IamProviderIdentifier ,
	          TitleId ,
	          FamilyName ,
	          GivenNames ,
	          SuffixId ,
	          LocalProviderCode,
	          DeactivatedDate,
	          DateCreated ,
	          UserCreated ,
	          DateModified ,
	          UserModified
	        )
	VALUES  ( @IamProviderIdentifier ,
	          @TitleId ,
	          @FamilyName , 
	          @GivenNames , 
	          @SuffixId , 
	          @LocalProviderCode,
	          @DeactivatedDate,
	          GETDATE() , 
	          @UserModified , 
	          GETDATE() , 
	          @UserModified  
	        )
	        
	SELECT @intErrorCode = @@ERROR , @HealthProviderIndividualId = SCOPE_IdENTITY()
	
	INSERT INTO HealthProviderIndividualHpii
		(
			HealthProviderIndividualId,
			HealthProviderOrganisationNetworkId,
			Hpii,
			HpiiLastValidated,
			HpiiStatusId,
			DateCreated,
			UserCreated,
			DateModified,
			UserModified
		) 
	VALUES
		( 
			@HealthProviderIndividualId,
			@HealthProviderOrganisationNetworkId,
			@HpiI,
			@HpiiLastValidated,
			@HpiiStatusId,
			GETDATE(), 
	        @UserModified, 
	        GETDATE(), 
	        @UserModified  
		)
	
    IF @intErrorCode = 0
    BEGIN
	SELECT
		hcp.HealthProviderIndividualId,
		hcp.IamProviderIdentifier,
		hpih.HpiI,
		hpih.HpiILastValidated,
		hpih.HpiiStatusId,
		
		hcp.TitleId,
		t.Description AS Title,
		
		hcp.FamilyName,
		hcp.GivenNames,
		hcp.DeactivatedDate,		
		hcp.SuffixId,
		s.Description AS Suffix,
		hcp.LocalProviderCode,
		hcp.DateCreated,
		hcp.UserCreated,
		hcp.DateModified,
		hcp.UserModified
		
	FROM hips.HealthProviderIndividual AS hcp 
	INNER JOIN hips.HealthProviderIndividualHpii AS hpih ON hcp.HealthProviderIndividualId = hpih.HealthProviderIndividualId AND hpih.HealthProviderOrganisationNetworkId = @HealthProviderOrganisationNetworkId 
	LEFT OUTER JOIN hips.Title AS t ON t.TitleId = hcp.TitleId
	LEFT OUTER JOIN hips.Suffix AS s ON s.SuffixId = hcp.SuffixId
	WHERE @HealthProviderIndividualId = hcp.HealthProviderIndividualId

    END

    RETURN(@intErrorCode)

	

END
GO

GO
GRANT EXEC ON [hips].[HealthProviderIndividualInsert] TO RunStoredProcedure
GO

